var traceWindow = null;
var traceText = '';
var MAX_LEVEL_TRACED = 3;     // trace is written if level <= MAX_LEVEL_TRACED
var MIN_LEVEL_VALUE = 1;
var MAX_LEVEL_VALUE = 3;
var MAX_TRACE_BUFFER_SIZE = 10000;  // max number of bytes held in 'traceText'
var TRACE_URL = '/html/ui/z/trace.html';

function trace(traceLevel, text)
{
   checkTraceWindow();
            
   if ((traceLevel == null) || (traceLevel == EMPTY) || 
       (traceLevel > MAX_LEVEL_VALUE) || (traceLevel < MIN_LEVEL_VALUE))
      text = 'Error, invalid trace level passed to trace(), trace level is [' + traceLevel + ']' 
             + ', trace text is [' + text + ']';
   else 
   {
      if (traceLevel <= MAX_LEVEL_TRACED)
      {
         var s = text + '<br>';
         if (traceWindow == null)
         {
            if (traceText.length > MAX_TRACE_BUFFER_SIZE)
            {
               // delete the first 20%
               var t = traceText.substr(traceText.length * .8);

               // find the start of a trace statement.
               var index = t.indexOf('<br>');
               if (index == -1)
                  index = 0;
               else
                  index = index + 4;  // skip past <br>
               var t = t.substr(index);
               traceText = t;
            }
            traceText = traceText + s;
         }
         else
            traceWindow.document.write(s);
      }
   }
}

function getTrace()
{
   return traceText;
}

function checkTraceWindow()
{
   try
   {
      // See if the trace window was displayed then closed.
      if ((traceWindow != null) && (traceWindow.document == null))
      {
         traceWindow = null;
         traceText = '';
      }
   }
   catch (e)   // IE throws an exception
   {
      traceWindow = null;
   }
}

function displayTrace()
{
   checkTraceWindow();
  
   if (traceWindow == null)
   {
      traceWindow = window.open(TRACE_URL, 'Trace', 'resizable,scrollbars,height=700,width=400');
      //traceWindow.onunload = traceWindowUnloaded;    // does not work ???
      if (traceText != '')
      {
         traceWindow.document.write(traceText);
         //traceText = '';
      }
   }
}

function clearTrace()
{
   traceText = '';
}

function traceWindowUnloaded()
{
   traceWindow = null;
   traceText = 'Trace window closed<br>';
}
